/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.common.entity.projectile.AbstractExplosive;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.util.properties.Properties;
import dev.toma.gunsrpg.util.properties.PropertyKey;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class Grenade
extends AbstractExplosive {
    private static final PropertyKey<IStickContext> STICK_CONTEXT = PropertyKey.newKey("stick_ctx");
    private static final float BOUNCE_MODIFIER = 0.2f;
    private static final Vector3d AIR_DRAG_MULTIPLIER = new Vector3d((double)0.97f, (double)0.97f, (double)0.97f);
    private static final Vector3d GROUND_DRAG_MULTIPLIER = new Vector3d(0.7, 0.7, 0.7);
    private static final int FUSE_DELAY = 70;
    private boolean bounced;

    public Grenade(EntityType<? extends Grenade> type, World world) {
        super((EntityType<? extends AbstractExplosive>)type, world);
    }

    public Grenade(EntityType<? extends Grenade> type, World world, LivingEntity owner) {
        super((EntityType<? extends AbstractExplosive>)type, world, owner);
    }

    @Override
    public void func_70071_h_() {
        IStickContext context;
        Vector3d to;
        Vector3d from;
        RayTraceContext context2;
        BlockRayTraceResult rayTraceResult;
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        Vector3d deltaMovement = this.func_213322_ci();
        double prevMotionX = deltaMovement.field_72450_a;
        double prevMotionY = deltaMovement.field_72448_b;
        double prevMotionZ = deltaMovement.field_72449_c;
        if (!this.field_70170_p.field_72995_K && (rayTraceResult = this.field_70170_p.func_217299_a(context2 = new RayTraceContext(from = this.func_213303_ch(), to = from.func_72441_c(deltaMovement.field_72450_a, deltaMovement.field_72448_b, deltaMovement.field_72449_c), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))) != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.onCollided(rayTraceResult.func_216347_e().func_72441_c(0.0, 0.5, 0.0));
        }
        this.updateDirection();
        Vector3d pos = this.func_213303_ch();
        this.checkForCollisions(pos, pos.func_178787_e(deltaMovement));
        this.func_213315_a(MoverType.SELF, deltaMovement);
        deltaMovement = this.func_213322_ci();
        boolean bouncedThisTick = false;
        double bounceX = deltaMovement.field_72450_a;
        double bounceY = deltaMovement.field_72448_b;
        double bounceZ = deltaMovement.field_72449_c;
        if (deltaMovement.field_72450_a != prevMotionX) {
            bounceX = (double)-0.2f * prevMotionX;
            bouncedThisTick = true;
        }
        if (deltaMovement.field_72448_b != prevMotionY) {
            bounceY = (double)-0.2f * prevMotionY;
            bouncedThisTick = true;
        }
        if (deltaMovement.field_72449_c != prevMotionZ) {
            bounceZ = (double)-0.2f * prevMotionZ;
            bouncedThisTick = true;
        }
        if (bouncedThisTick) {
            this.bounced = true;
            this.onCollided(this.func_213303_ch());
            if (this.getProperty(Properties.STICKY).booleanValue() && (context = this.getProperty(STICK_CONTEXT)) == null) {
                this.setProperty(STICK_CONTEXT, new BlockStickContext(this.func_213303_ch()));
            }
        }
        if (this.bounced && this.getProperty(Properties.STICKY).booleanValue()) {
            context = this.getProperty(STICK_CONTEXT);
            if (context != null) {
                context.update();
            }
        } else {
            this.func_213293_j(bounceX, bounceY, bounceZ);
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.039, 0.0));
            }
            this.func_213317_d(this.func_213322_ci().func_216369_h(AIR_DRAG_MULTIPLIER));
            if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_216369_h(GROUND_DRAG_MULTIPLIER));
            }
        }
        if (this.bounced && this.field_70173_aa >= 70) {
            this.onCollided(this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0));
        }
    }

    @Override
    protected void updateDirection() {
        Vector3d delta = this.func_213322_ci();
        double dx = delta.field_72450_a;
        double dy = delta.field_72448_b;
        double dz = delta.field_72449_c;
        float motionSqrt = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.field_70127_C = this.field_70125_A = -((float)(MathHelper.func_181159_b((double)dy, (double)motionSqrt) * 57.29577951308232));
    }

    @Override
    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        if (this.getProperty(Properties.STICKY).booleanValue()) {
            this.setProperty(STICK_CONTEXT, new BlockStickContext(result.func_216347_e()));
        }
    }

    @Override
    protected void handleEntityCollision(EntityRayTraceResult result) {
        super.handleEntityCollision(result);
        if (this.getProperty(Properties.STICKY).booleanValue()) {
            this.setProperty(STICK_CONTEXT, new EntityStickContext(result.func_216348_a()));
        }
    }

    @Override
    public void onCollided(Vector3d impact) {
        boolean isImpact = this.getProperty(Properties.IMPACT);
        if ((isImpact || this.field_70173_aa >= 70) && this.func_70089_S()) {
            IReaction reaction = this.getProperty(Properties.REACTION);
            if (reaction != null) {
                reaction.react(this, impact, this.field_70170_p);
            }
            this.func_70106_y();
        }
    }

    class EntityStickContext
    implements IStickContext {
        final Entity entity;

        public EntityStickContext(Entity entity) {
            this.entity = entity;
        }

        @Override
        public void update() {
            if (this.entity.func_70089_S()) {
                Grenade grenade = Grenade.this;
                EntitySize size = this.entity.func_213305_a(this.entity.func_213283_Z());
                double yy = (double)size.field_220316_b / 2.0;
                grenade.func_226286_f_(this.entity.func_226277_ct_(), this.entity.func_226278_cu_() + yy, this.entity.func_226281_cx_());
                grenade.func_213293_j(0.0, 0.0, 0.0);
            } else {
                Grenade.this.func_213293_j(0.0, -0.039, 0.0);
            }
        }
    }

    class BlockStickContext
    implements IStickContext {
        final Vector3d pos;

        public BlockStickContext(Vector3d pos) {
            this.pos = pos;
        }

        @Override
        public void update() {
            Grenade grenade = Grenade.this;
            grenade.func_70107_b(this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c);
            grenade.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    static interface IStickContext {
        public void update();
    }
}

